/*
 * Decompiled with CFR 0.152.
 */
import Multicast.OverlayNeighbor;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import prominence.util.Queue;

public class Signalling
implements Runnable {
    protected Hashtable neighbors;
    protected Hashtable old_neighbors;
    protected OverlayNeighbor nb;
    protected Stato state;
    protected Thread exec;
    protected TextArea outputArea;
    protected TextArea outputArea2;
    protected TextArea outputArea3;
    protected Label label5;
    protected Label label6;
    TextField field1;
    TextField field2;
    TextField field3;
    TextField field4;
    TextField field5;
    TextField field6;
    TextField field7;
    TextField field8;
    TextField field9;
    TextField field10;
    protected TREE_CREATETimer ttimer;
    protected IDR_Timer esiTimer;
    protected pktTreeCreate forwardingTreeCreate;
    protected pktTreeCreate lastTreeCreateSent;
    protected InetAddress nullIP;
    protected long HELLO_INT;
    protected long JOIN_INT;
    protected long fast_HELLO_INT;
    protected long req_interval;
    protected long TCinterval;
    protected int TCflag;
    protected MulticastSignallingReceiver MSigRec;
    protected MulticastSignallingSender MSigSend;
    protected UnicastSignallingSender USigSend;
    protected UnicastSignallingReceiver USigRec;
    protected int sig_port;
    protected int broadcast_port;
    protected InetAddress multicast_address;
    protected InetAddress local_address;
    protected Queue q;
    private DB_Contest db = new DB_Contest("obamp.cfg");
    public boolean fastHelloActive;
    protected String signalling_use;
    protected long Alive_Hello_intervall;
    protected long Allowed_Alive_Hello_loss;
    protected long Allowed_Fast_Hello_loss;
    protected long Allowed_Hello_loss;
    protected long Allowed_Join_loss;
    protected refreshGUI rgui;
    protected Checkbox sig_dump_box;
    protected int TC_counter;
    protected int OUTER_TC_period;
    protected double Delay_Unit;
    protected Checkbox check;
    protected String cmd;
    protected String Operative_System;
    String[] mesh_list_vector;
    InetAddress[] mesh_list_vector_Inet;
    JoinedListEntry[] JoinedList;
    InetAddress[] MEMBER_LIST;
    byte myIPaddressbyte;

    public Signalling(Checkbox check_) throws Exception {
        this.local_address = InetAddress.getByName(this.db.get("local_address"));
        this.sig_port = new Integer(this.db.get("signalling_port"));
        this.broadcast_port = new Integer(this.db.get("multicast_signalling_port"));
        this.multicast_address = InetAddress.getByName(this.db.get("multicast_address"));
        this.req_interval = new Long(this.db.get("Join_Req_intervall"));
        this.TCinterval = new Long(this.db.get("TC_intervall"));
        this.HELLO_INT = new Long(this.db.get("Hello_intervall"));
        this.JOIN_INT = new Long(this.db.get("Join_intervall"));
        this.fast_HELLO_INT = new Long(this.db.get("Fast_Hello_intervall"));
        this.Operative_System = new String(this.db.get("Operative_System")).toString();
        this.Alive_Hello_intervall = new Long(this.db.get("Alive_Hello_intervall"));
        this.Allowed_Alive_Hello_loss = new Long(this.db.get("Allowed_Alive_Hello_loss"));
        this.Allowed_Fast_Hello_loss = new Long(this.db.get("Allowed_Fast_Hello_loss"));
        this.Allowed_Hello_loss = new Long(this.db.get("Allowed_Hello_loss"));
        this.Allowed_Join_loss = new Long(this.db.get("Allowed_Join_loss"));
        this.OUTER_TC_period = new Integer(this.db.get("OUTER_TC_period"));
        this.Delay_Unit = new Double(this.db.get("Delay_Unit"));
        this.state = new Stato(this.local_address, this.sig_port);
        this.state.MAX_TTL = new Integer(this.db.get("Join_Req_max_TTL"));
        this.state.hello_max_ttl = new Integer(this.db.get("Hello_max_TTL"));
        this.q = new Queue();
        this.neighbors = new Hashtable();
        this.old_neighbors = new Hashtable();
        this.check = check_;
        if (this.Operative_System.equals("Windows")) {
            this.cmd = "route print ";
        } else if (this.Operative_System.equals("Linux")) {
            this.cmd = "route -n ";
        }
        this.fastHelloActive = true;
        this.nullIP = InetAddress.getByName("0.0.0.0");
        this.forwardingTreeCreate = null;
        this.TCflag = 0;
        this.signalling_use = "lock";
        this.TC_counter = 3;
        this.exec = new Thread((Runnable)this, "SIGNALLING");
        this.exec.start();
    }

    public void setStato(Stato state_) {
        this.state = state_;
    }

    public void setTextArea(TextArea area1, TextArea area2, TextArea area3, Label label5_, Label label6_, Checkbox sig_dump_box_) {
        this.outputArea = area1;
        this.outputArea2 = area2;
        this.outputArea3 = area3;
        this.label5 = label5_;
        this.label6 = label6_;
        this.sig_dump_box = sig_dump_box_;
    }

    boolean CHECK_SEQ_NUM(byte stateSN_, byte pktSN_) {
        int pktSN;
        int stateSN = stateSN_;
        if (stateSN < 0) {
            stateSN += 256;
        }
        if ((pktSN = pktSN_) < 0) {
            pktSN += 256;
        }
        if (Math.abs(pktSN - stateSN) > 5) {
            return true;
        }
        return stateSN < pktSN;
    }

    public void SetNeighborMinDistance() {
        this.state.NeighborMinDistance = 100;
        Enumeration e = this.neighbors.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(key);
            if (nb.distance <= 0 || this.state.NeighborMinDistance <= nb.distance) continue;
            this.state.NeighborMinDistance = nb.distance;
        }
    }

    public void node_map_insert(String addr, byte[] pkt_) {
        int id = 0;
        for (int t = 0; t < this.mesh_list_vector.length && !this.mesh_list_vector[t].equals(addr); ++t) {
            ++id;
        }
        int insert_char = 1;
        int ref_byte = id / 8;
        int ref_bit = id % 8;
        insert_char = (byte)(insert_char << ref_bit);
        pkt_[ref_byte + 6] = (byte)(pkt_[ref_byte + 6] | insert_char);
    }

    public void node_map_insert_Join(String addr, byte[] pkt_) {
        int id = 0;
        for (int t = 0; t < this.mesh_list_vector.length && !this.mesh_list_vector[t].equals(addr); ++t) {
            ++id;
        }
        int insert_char = 1;
        int ref_byte = id / 8;
        int ref_bit = id % 8;
        insert_char = (byte)(insert_char << ref_bit);
        pkt_[ref_byte] = (byte)(pkt_[ref_byte] | insert_char);
    }

    public void node_map_insert_Join(int id, byte[] pkt_) {
        int insert_char = 1;
        int ref_byte = id / 8;
        int ref_bit = id % 8;
        insert_char = (byte)(insert_char << ref_bit);
        pkt_[ref_byte] = (byte)(pkt_[ref_byte] | insert_char);
    }

    public void node_map_insert(int id_, byte[] pkt_) {
        int id = id_;
        int insert_char = 1;
        int ref_byte = id / 8;
        int ref_bit = id % 8;
        insert_char = (byte)(insert_char << ref_bit);
        pkt_[ref_byte + 6] = (byte)(pkt_[ref_byte + 6] | insert_char);
    }

    public boolean node_map_lookup(String addr, byte[] pkt_) {
        int id = 0;
        for (int t = 0; t < this.mesh_list_vector.length && !this.mesh_list_vector[t].equals(addr); ++t) {
            ++id;
        }
        int insert_char = 1;
        int ref_byte = id / 8;
        int ref_bit = id % 8;
        return (pkt_[ref_byte + 6] & (insert_char = (int)((byte)(insert_char << ref_bit)))) != 0;
    }

    public boolean node_map_lookup_Join(String addr, byte[] pkt_) {
        int id = 0;
        for (int t = 0; t < this.mesh_list_vector.length && !this.mesh_list_vector[t].equals(addr); ++t) {
            ++id;
        }
        int insert_char = 1;
        int ref_byte = id / 8;
        int ref_bit = id % 8;
        return (pkt_[ref_byte] & (insert_char = (int)((byte)(insert_char << ref_bit)))) != 0;
    }

    public boolean node_map_lookup_Join(int id, byte[] pkt_) {
        int insert_char = 1;
        int ref_byte = id / 8;
        int ref_bit = id % 8;
        return (pkt_[ref_byte] & (insert_char = (int)((byte)(insert_char << ref_bit)))) != 0;
    }

    public boolean node_map_lookup(int id_, byte[] pkt_) {
        int id = id_;
        int insert_char = 1;
        int ref_byte = id / 8;
        int ref_bit = id % 8;
        return (pkt_[ref_byte + 6] & (insert_char = (int)((byte)(insert_char << ref_bit)))) != 0;
    }

    public void update_last_recv_time(InetAddress ip) {
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(ip);
        if (nb == null) {
            return;
        }
        nb.last_pkt_recv_time = System.currentTimeMillis();
    }

    public void update_last_send_time(InetAddress ip) {
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(ip);
        if (nb == null) {
            return;
        }
        nb.last_pkt_sent_time = System.currentTimeMillis();
    }

    public void sendHelloConf(byte SequenceNumber, InetAddress dest_addr, byte TTL) {
        pktHelloConf pktnew = new pktHelloConf(SequenceNumber, this.state.MyAddress, dest_addr, this.state.CoreAddress, TTL, this);
        byte[] data = pktnew.GetpktHelloConf();
        UnicastData usp = new UnicastData(data, dest_addr);
        this.USigSend.q.add(usp);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("send Hello-Conf to " + dest_addr + "\n");
        }
    }

    public double Get_Tree_Create_Delay(OverlayNeighbor nb) {
        double delay;
        double uniform = new Random().nextDouble();
        if (this.Is_Nearest(nb.IPAddress) || nb.distance == 1) {
            delay = 0.0;
        } else {
            int dist = this.Get_Dist(nb.IPAddress);
            delay = (double)(dist - 1) * this.Delay_Unit + uniform * 0.25;
        }
        return delay;
    }

    boolean Is_Nearest(InetAddress ip) {
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(ip);
        double dist = 10000.0;
        Enumeration e = this.neighbors.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
            if (!(1.0 * (double)value.distance + 0.001 * (double)value.IP < dist)) continue;
            dist = 1.0 * (double)value.distance + 0.001 * (double)value.IP;
        }
        return 1.0 * (double)nb.distance + 0.001 * (double)nb.IP == dist;
    }

    int Get_Dist(InetAddress ip) {
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(ip);
        if (nb.distance != 0) {
            return nb.distance;
        }
        return 1000;
    }

    public void sendTreeCreate() {
        byte[] pktNodeMap = new byte[14];
        this.node_map_insert(this.state.getAddressString(), pktNodeMap);
        Enumeration e = this.neighbors.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
            if (!this.Is_Nearest(value.IPAddress) && value.distance != 1 || !value.CoreAddress.equals(this.state.CoreAddress)) continue;
            this.node_map_insert(value.IPAddress.toString().substring(1, value.IPAddress.toString().length()), pktNodeMap);
        }
        boolean multicast_done = false;
        int TCSN = this.state.TreeCreateSequenceNumber;
        if (TCSN < 0) {
            TCSN += 256;
        }
        if (++TCSN > 255) {
            TCSN = 1;
        }
        this.state.TreeCreateSequenceNumber = (byte)TCSN;
        Enumeration en = this.neighbors.keys();
        while (en.hasMoreElements()) {
            UnicastData uData;
            pktTreeCreate packet;
            byte delay;
            Object key = en.nextElement();
            OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
            if (this.check.getState()) {
                if (value.distance > 1) {
                    delay = this.Is_Nearest(value.IPAddress) ? (byte)0 : 1;
                    packet = new pktTreeCreate(this.state.TreeCreateSequenceNumber, this.state.MyAddress, this.state.CoreAddress, delay, pktNodeMap, this);
                    uData = new UnicastData(packet.getData(), value.IPAddress);
                    this.USigSend.q.add(uData);
                    if (!this.sig_dump_box.getState()) continue;
                    this.outputArea.append(this.state.TreeCreateSequenceNumber + " send Tree-Create to " + value.GetIPaddress() + "\n");
                    continue;
                }
                if (value.distance != 1) continue;
                delay = 0;
                if (multicast_done) continue;
                packet = new pktTreeCreate(this.state.TreeCreateSequenceNumber, this.state.MyAddress, this.state.CoreAddress, delay, pktNodeMap, this);
                MulticastData mData = new MulticastData(packet.getData(), 1);
                this.MSigSend.q.add(mData);
                multicast_done = true;
                if (!this.sig_dump_box.getState()) continue;
                this.outputArea.append(this.state.TreeCreateSequenceNumber + " send broadcast Tree-Create" + "\n");
                continue;
            }
            if (value.distance > 1) {
                delay = this.Is_Nearest(value.IPAddress) ? (byte)0 : 1;
                packet = new pktTreeCreate(this.state.TreeCreateSequenceNumber, this.state.MyAddress, this.state.CoreAddress, delay, pktNodeMap, this);
                uData = new UnicastData(packet.getData(), value.IPAddress);
                this.USigSend.q.add(uData);
                if (!this.sig_dump_box.getState()) continue;
                this.outputArea.append(this.state.TreeCreateSequenceNumber + " send Tree-Create to " + value.GetIPaddress() + "\n");
                continue;
            }
            if (value.distance != 1) continue;
            delay = 0;
            packet = new pktTreeCreate(this.state.TreeCreateSequenceNumber, this.state.MyAddress, this.state.CoreAddress, delay, pktNodeMap, this);
            uData = new UnicastData(packet.getData(), value.IPAddress);
            this.USigSend.q.add(uData);
            if (!this.sig_dump_box.getState()) continue;
            this.outputArea.append(this.state.TreeCreateSequenceNumber + " send Tree-Create to " + value.GetIPaddress() + "\n");
        }
        if (this.TC_counter % this.OUTER_TC_period == 0) {
            this.sendOuterTreeCreate();
        }
        ++this.TC_counter;
    }

    void sendOuterTreeCreate() {
        try {
            int h;
            String addressIP;
            String str_route_print1;
            BufferedReader route_printb1 = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(this.cmd).getInputStream()));
            while ((str_route_print1 = route_printb1.readLine()) != null && str_route_print1.lastIndexOf("Metric") < 0) {
            }
            route_printb1.mark(1);
            if (this.Operative_System.equals("Windows")) {
                while ((str_route_print1 = route_printb1.readLine()) != null && str_route_print1.lastIndexOf("=") < 0) {
                    addressIP = str_route_print1.trim();
                    addressIP = addressIP.substring(0, addressIP.indexOf(32));
                    for (h = 0; h < this.mesh_list_vector.length; ++h) {
                        if (!this.mesh_list_vector[h].equals(addressIP)) continue;
                        this.MEMBER_LIST[h] = InetAddress.getByName(addressIP);
                    }
                }
            } else if (this.Operative_System.equals("Linux")) {
                while ((str_route_print1 = route_printb1.readLine()) != null) {
                    addressIP = str_route_print1.substring(0, str_route_print1.indexOf(32));
                    for (h = 0; h < this.mesh_list_vector.length; ++h) {
                        if (!this.mesh_list_vector[h].equals(addressIP)) continue;
                        this.MEMBER_LIST[h] = InetAddress.getByName(addressIP);
                    }
                }
            }
            int IPcore = this.state.getAddressInt(this.state.CoreAddress);
            for (int r = 0; r < this.MEMBER_LIST.length; ++r) {
                int IP;
                if (this.MEMBER_LIST[r] == null || (IP = this.state.getAddressInt(this.MEMBER_LIST[r])) >= IPcore || !this.SenderISValid(this.MEMBER_LIST[r]) || this.MEMBER_LIST[r].equals(this.state.MyAddress)) continue;
                this.sendOuterTreeCreate(this.MEMBER_LIST[r]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void sendOuterTreeCreate(InetAddress destaddr) {
        int TCSN = this.state.TreeCreateSequenceNumber;
        if (TCSN < 0) {
            TCSN += 256;
        }
        if (++TCSN > 255) {
            TCSN = 1;
        }
        this.state.TreeCreateSequenceNumber = (byte)TCSN;
        byte[] pktNodeMap = new byte[14];
        byte[] pktJoinedList = new byte[8];
        for (int i = 0; i < this.JoinedList.length; ++i) {
            if (this.JoinedList[i] == null) continue;
            this.node_map_insert_Join(i, pktJoinedList);
        }
        pktOuterTreeCreate pkt = new pktOuterTreeCreate(this.state.TreeCreateSequenceNumber, this.state.MyAddress, this.state.CoreAddress, 0, pktNodeMap, pktJoinedList, this);
        byte[] pkt_ = pkt.getData();
        pkt_[0] = 14;
        pkt_[1] = 127;
        UnicastData uData = new UnicastData(pkt_, destaddr);
        this.USigSend.q.add(uData);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append(this.state.TreeCreateSequenceNumber + " send OUTER Tree-Create a " + destaddr + "\n");
        }
    }

    void sendTREE_CREATE_NACK(InetAddress dest) {
        int TCNSN = this.state.TreeCreateNackSequenceNumber;
        if (TCNSN < 0) {
            TCNSN += 256;
        }
        if (++TCNSN > 255) {
            TCNSN = 1;
        }
        this.state.TreeCreateNackSequenceNumber = (byte)TCNSN;
        pktTreeCreateNack pkt = new pktTreeCreateNack(this.state.TreeCreateNackSequenceNumber, this.state.getIPAddress(), this.state.CoreAddress, this);
        this.state.NACKStatus = true;
        byte[] data = pkt.GetpktTreeCreateNack();
        new IDR_Timer(this, data, dest, 4, 1.0);
        UnicastData usp = new UnicastData(data, dest);
        this.USigSend.q.add(usp);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("send Tree-Create-Nack to " + dest + "\n");
        }
    }

    void retransmitTREE_CREATE_NACK(InetAddress dest, byte[] pkt_) {
        this.state.NACKStatus = true;
        new IDR_Timer(this, pkt_, dest, 4, 1.0);
        UnicastData usp = new UnicastData(pkt_, dest);
        this.USigSend.q.add(usp);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("send Tree-Create-Nack to " + dest + "\n");
        }
    }

    void sendTreeCreateAck(InetAddress dest) {
        int TCASN = this.state.TreeCreateAckSequenceNumber;
        if (TCASN < 0) {
            TCASN += 256;
        }
        if (++TCASN > 255) {
            TCASN = 1;
        }
        this.state.TreeCreateAckSequenceNumber = (byte)TCASN;
        pktTreeCreateAck pkt = new pktTreeCreateAck(this.state.TreeCreateAckSequenceNumber, this.state.getIPAddress(), this.state.getIPCoreAddress(), this);
        this.state.ACKStatus = true;
        this.SET_TREE_LINK(dest);
        byte[] data = pkt.GetpktTreeCreateAck();
        new IDR_Timer(this, data, dest, 3, 1.0);
        UnicastData usp = new UnicastData(data, dest);
        this.USigSend.q.add(usp);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append(this.state.TreeCreateAckSequenceNumber + " send Tree-Create-Ack to " + dest + "\n");
        }
    }

    void retransmitTreeCreateAck(InetAddress dest, byte[] pkt_) {
        this.state.ACKStatus = true;
        new IDR_Timer(this, pkt_, dest, 3, 1.0);
        UnicastData usp = new UnicastData(pkt_, dest);
        this.USigSend.q.add(usp);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("send Tree-Create-Ack to " + dest + "\n");
        }
    }

    void sendTreeCreateConf(InetAddress dest, byte SN) {
        pktTreeCreateConf pkt = new pktTreeCreateConf(SN, this.state.getIPAddress(), this.state.CoreAddress, this);
        byte[] data = pkt.GetpktTreeCreateConf();
        UnicastData usp = new UnicastData(data, dest);
        this.USigSend.q.add(usp);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append(SN + " send Tree-Create-Conf to " + dest + "\n");
        }
    }

    void sendTreeCreateNackConf(InetAddress dest, byte SN) {
        pktTreeCreateNackConf pkt = new pktTreeCreateNackConf(SN, this.state.getIPAddress(), this.state.CoreAddress, this);
        byte[] data = pkt.GetpktTreeCreateNackConf();
        UnicastData usp = new UnicastData(data, dest);
        this.USigSend.q.add(usp);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append(SN + " send Tree-Create-Nack-Conf to " + dest + "\n");
        }
    }

    public void SET_TREE_LINK(InetAddress key) {
        OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
        value.istree = true;
        value.last_pkt_recv_time = System.currentTimeMillis();
    }

    public void CLEAR_TREE_LINK(InetAddress key) {
        if (!key.equals(this.state.MyAddress)) {
            OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
            value.istree = false;
            return;
        }
    }

    public void nb_insert(InetAddress id, InetAddress CoreAddress_) {
        byte[] ind = id.getAddress();
        byte SourceIP = ind[3];
        if (this.neighbors.containsKey(id)) {
            OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(id);
            nb.Texpire = CoreAddress_.equals(this.state.CoreAddress) ? System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Hello_loss * (double)this.HELLO_INT) : System.currentTimeMillis() + (long)(3.5 * (double)this.TCinterval);
            nb.CoreAddress = CoreAddress_;
            return;
        }
        if (this.old_neighbors.containsKey(id)) {
            OverlayNeighbor onb = (OverlayNeighbor)this.old_neighbors.get(id);
            onb.distance = 4;
            onb.Texpire = System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Hello_loss * (double)this.HELLO_INT);
            onb.CoreAddress = CoreAddress_;
            this.neighbors.put(id, onb);
            this.old_neighbors.remove(id);
            return;
        }
        OverlayNeighbor new_nb = new OverlayNeighbor(id);
        new_nb.Texpire = System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Hello_loss * (double)this.HELLO_INT);
        new_nb.CoreAddress = CoreAddress_;
        new_nb.IP = SourceIP;
        this.neighbors.put(id, new_nb);
    }

    public boolean SenderISValid(InetAddress address) {
        OverlayNeighbor nb_old;
        return this.old_neighbors == null || (nb_old = (OverlayNeighbor)this.old_neighbors.get(address)) == null || !((double)(System.currentTimeMillis() - nb_old.last_failure_time) < 1.5 * (double)this.Allowed_Alive_Hello_loss * (double)this.Alive_Hello_intervall);
    }

    public void receive(DatagramPacket p) {
        byte[] packet = p.getData();
        ByteArrayInputStream biStream = new ByteArrayInputStream(packet, 0, p.getLength());
        DataInputStream diStream = new DataInputStream(biStream);
        int MID = packet[0];
        if (MID < 0) {
            MID += 256;
        }
        switch (MID) {
            case 5: {
                this.receiveTreeCreate(packet);
                break;
            }
            case 6: {
                this.receiveTreeCreateNak(diStream);
                break;
            }
            case 8: {
                this.receiveTreeCreateAck(diStream);
                break;
            }
            case 9: {
                this.receiveTreeCreateConf(diStream);
                break;
            }
            case 10: {
                this.receiveTreeCreateNackConf(diStream);
                break;
            }
            case 12: {
                this.receiveHelloConf(diStream);
                break;
            }
            case 14: {
                this.receiveOuterTreeCreate(packet);
                break;
            }
            case 15: {
                this.receiveJoin(packet);
            }
        }
    }

    void recvTREE_CREATE(pktTreeCreate pkt) {
        if (!pkt.IPCoreAddress.equals(this.state.CoreAddress) && !pkt.SourceIPAddress.equals(this.state.ParentId)) {
            if (this.sig_dump_box.getState()) {
                this.outputArea.append("discarded Tree-Create from " + pkt.IPCoreAddress + " different Core or Parent ID\n");
            }
            return;
        }
        if (!this.SenderISValid(pkt.SourceIPAddress)) {
            return;
        }
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
        if (nb == null) {
            this.nb_insert(pkt.SourceIPAddress, pkt.IPCoreAddress);
            nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
            if (pkt.IPCoreAddress.equals(this.state.CoreAddress)) {
                nb.Texpire = System.currentTimeMillis() + 100L;
            }
        }
        nb.CoreAddress = pkt.IPCoreAddress;
        this.node_map_insert(this.state.getAddressString(), pkt.data);
        if (this.CORE_RESOLUTION(pkt)) {
            if (this.CHECK_SEQ_NUM(pkt)) {
                if (this.state.getTreeCreateSequenceNumber() == pkt.SequenceNumber) {
                    ++nb.Number_of_TCS;
                    return;
                }
                if (!this.state.ACKStatus && !this.state.NACKStatus) {
                    this.state.LastTreeCreateIn = pkt.SourceIPAddress;
                    this.forwardingTreeCreate = pkt;
                    ++nb.Number_of_TCS;
                    this.state.TreeCreateSequenceNumber = pkt.SequenceNumber;
                    if (this.state.ParentId.equals(pkt.SourceIPAddress)) {
                        this.forwardTREE_CREATE(pkt);
                    } else {
                        this.sendTreeCreateAck(pkt.SourceIPAddress);
                    }
                }
            } else if (this.sig_dump_box.getState()) {
                this.outputArea.append("discarded Tree-Create from " + pkt.SourceIPAddress + " Sequence Number NOT VALID \n");
            }
        } else if (this.sig_dump_box.getState()) {
            this.outputArea.append("discarded Tree-Create from " + pkt.SourceIPAddress + " CORE_RESOLUTION \n");
        }
    }

    public void forwardTREE_CREATE(pktTreeCreate pkt) {
        byte[] pktNodeMap = new byte[14];
        byte[] pktdata = pkt.getData();
        for (int element = 6; element < pktdata.length; ++element) {
            pktNodeMap[element] = pktdata[element];
        }
        this.node_map_insert(this.state.getAddressString(), pktNodeMap);
        Enumeration e = this.neighbors.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
            if (!this.Is_Nearest(value.IPAddress) && value.distance != 1 || !value.CoreAddress.equals(this.state.CoreAddress)) continue;
            this.node_map_insert(value.IPAddress.toString().substring(1, value.IPAddress.toString().length()), pktNodeMap);
        }
        boolean multicast_done = false;
        Enumeration en = this.neighbors.keys();
        while (en.hasMoreElements()) {
            UnicastData uData;
            pktTreeCreate packet;
            byte delay;
            Object key = en.nextElement();
            OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
            if (this.node_map_lookup(value.IPAddress.toString().substring(1, value.IPAddress.toString().length()), pkt.getData())) continue;
            if (this.check.getState()) {
                if (value.distance > 1) {
                    delay = this.Is_Nearest(value.IPAddress) ? (byte)0 : 1;
                    packet = new pktTreeCreate(pkt.SequenceNumber, this.state.MyAddress, pkt.IPCoreAddress, delay, pktNodeMap, this);
                    uData = new UnicastData(packet.getData(), value.IPAddress);
                    this.USigSend.q.add(uData);
                    if (!this.sig_dump_box.getState()) continue;
                    this.outputArea.append(pkt.SequenceNumber + " forward Tree-Create to " + value.GetIPaddress() + "\n");
                    continue;
                }
                if (value.distance != 1) continue;
                delay = 0;
                if (multicast_done) continue;
                packet = new pktTreeCreate(pkt.SequenceNumber, this.state.MyAddress, pkt.IPCoreAddress, delay, pktNodeMap, this);
                MulticastData mData = new MulticastData(packet.getData(), 1);
                this.MSigSend.q.add(mData);
                multicast_done = true;
                if (!this.sig_dump_box.getState()) continue;
                this.outputArea.append(this.state.TreeCreateSequenceNumber + " forward Tree-Create" + "\n");
                continue;
            }
            if (value.distance > 1) {
                delay = this.Is_Nearest(value.IPAddress) ? (byte)0 : 1;
                packet = new pktTreeCreate(pkt.SequenceNumber, this.state.MyAddress, pkt.IPCoreAddress, delay, pktNodeMap, this);
                uData = new UnicastData(packet.getData(), value.IPAddress);
                this.USigSend.q.add(uData);
                if (!this.sig_dump_box.getState()) continue;
                this.outputArea.append(pkt.SequenceNumber + " forward Tree-Create to " + value.GetIPaddress() + "\n");
                continue;
            }
            if (value.distance != 1) continue;
            delay = 0;
            packet = new pktTreeCreate(pkt.SequenceNumber, this.state.MyAddress, pkt.IPCoreAddress, delay, pktNodeMap, this);
            uData = new UnicastData(packet.getData(), value.IPAddress);
            this.USigSend.q.add(uData);
            if (!this.sig_dump_box.getState()) continue;
            this.outputArea.append(pkt.SequenceNumber + " forward Tree-Create to " + value.GetIPaddress() + "\n");
        }
    }

    public void receiveTreeCreate(byte[] pkt_) {
        pktTreeCreate pkt = new pktTreeCreate(this.state.MyAddress);
        pkt.SetpktTreeCreate(pkt_, this);
        OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
        if (value == null) {
            this.nb_insert(pkt.SourceIPAddress, pkt.IPCoreAddress);
            value = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
            if (pkt.IPCoreAddress.equals(this.state.CoreAddress)) {
                value.Texpire = System.currentTimeMillis() + 100L;
            }
        }
        double delayB = !this.Is_Nearest(value.IPAddress) && pkt.delay == 1 ? this.Get_Tree_Create_Delay(value) : 0.0;
        delayB = Math.max(0.0, delayB);
        if (this.sig_dump_box.getState()) {
            this.outputArea.append(pkt.SequenceNumber + " received Tree-Create from " + value.IPAddress + " delay = " + delayB + "\n");
        }
        if (delayB > 0.0) {
            new IDR_Timer(this, pkt, 2, delayB);
        } else {
            this.recvTREE_CREATE(pkt);
        }
    }

    public void receiveOuterTreeCreate(byte[] pkt_) {
        if (!this.state.is_core) {
            pktOuterTreeCreate pkt = new pktOuterTreeCreate(this.state.MyAddress);
            pkt.SetpktOuterTreeCreate(pkt_, this);
            if (!this.SenderISValid(pkt.SourceIPAddress)) {
                return;
            }
            byte[] pktJoinedList = new byte[8];
            byte[] pktdata = pkt.getData();
            for (int element = 0; element < pktJoinedList.length; ++element) {
                pktJoinedList[element] = pktdata[element + 14];
            }
            for (int t = 0; t < this.mesh_list_vector.length; ++t) {
                if (!this.node_map_lookup_Join(t, pktJoinedList) && !pkt.SourceIPAddress.equals(this.mesh_list_vector_Inet[t]) || !this.SenderISValid(this.mesh_list_vector_Inet[t])) continue;
                this.JoinedList[t] = new JoinedListEntry("0", this.mesh_list_vector[t], System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Join_loss * (double)this.JOIN_INT), 0);
            }
            return;
        }
        pktOuterTreeCreate pkt = new pktOuterTreeCreate(this.state.MyAddress);
        pkt.SetpktOuterTreeCreate(pkt_, this);
        if (!this.SenderISValid(pkt.SourceIPAddress)) {
            return;
        }
        byte[] pktJoinedList = new byte[8];
        byte[] pktdata = pkt.getData();
        for (int element = 0; element < pktJoinedList.length; ++element) {
            pktJoinedList[element] = pktdata[element + 14];
        }
        if (pkt.SourceIPAddress.equals(this.state.MyAddress)) {
            return;
        }
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("received Outer Tree-Create from " + pkt.SourceIPAddress + "\n");
        }
        for (int t = 0; t < this.mesh_list_vector.length; ++t) {
            if (!this.node_map_lookup_Join(t, pktJoinedList) && !pkt.SourceIPAddress.equals(this.mesh_list_vector_Inet[t]) || !this.SenderISValid(this.mesh_list_vector_Inet[t])) continue;
            this.JoinedList[t] = new JoinedListEntry("0", this.mesh_list_vector[t], System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Join_loss * (double)this.JOIN_INT), 0);
        }
        byte[] pktTreeArray = new byte[14];
        for (int r = 0; r < 14; ++r) {
            pktTreeArray[r] = pktdata[r];
        }
        pktTreeCreate pktTree = new pktTreeCreate(this.state.MyAddress);
        pktTree.SetpktTreeCreate(pktTreeArray, this);
        if (this.CORE_RESOLUTION(pktTree)) {
            this.recvTREE_CREATE(pktTree);
        } else {
            this.sendOuterTreeCreate(pkt.SourceIPAddress);
        }
    }

    public void receiveTreeCreateNak(DataInputStream is) {
        pktTreeCreateNack pkt = new pktTreeCreateNack(this.state.MyAddress);
        pkt.SetpktTreeCreateNack(is, this);
        if (!this.SenderISValid(pkt.SourceIPAddress)) {
            return;
        }
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
        if (nb == null) {
            this.sendTreeCreateNackConf(pkt.SourceIPAddress, pkt.SequenceNumber);
            return;
        }
        if (this.CHECK_SEQ_NUM(nb.last_nack_sn, pkt.SequenceNumber) || nb.last_nack_sn == pkt.SequenceNumber) {
            this.CLEAR_TREE_LINK(pkt.SourceIPAddress);
            nb.last_nack_sn = pkt.SequenceNumber;
            nb.CoreAddress = pkt.IPCoreAddress;
            this.sendTreeCreateNackConf(pkt.SourceIPAddress, pkt.SequenceNumber);
        }
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("received Tree-Create-Nack from " + pkt.SourceIPAddress + "\n");
        }
    }

    public void receiveTreeCreateAck(DataInputStream is) {
        pktTreeCreateAck pkt = new pktTreeCreateAck(this.state.MyAddress);
        pkt.SetpktTreeCreateAck(is, this);
        if (!this.SenderISValid(pkt.SourceIPAddress)) {
            return;
        }
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
        if (nb == null) {
            this.nb_insert(pkt.SourceIPAddress, pkt.IPCoreAddress);
            nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
            if (pkt.IPCoreAddress.equals(this.state.CoreAddress)) {
                nb.Texpire = System.currentTimeMillis() + 100L;
            }
        }
        if (this.CHECK_SEQ_NUM(nb.last_ack_sn, pkt.SequenceNumber) || nb.last_ack_sn == pkt.SequenceNumber) {
            this.SET_TREE_LINK(pkt.SourceIPAddress);
            nb.last_ack_sn = pkt.SequenceNumber;
            nb.CoreAddress = pkt.IPCoreAddress;
            this.sendTreeCreateConf(pkt.SourceIPAddress, pkt.SequenceNumber);
        }
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("received Tree-Create-Ack from " + pkt.SourceIPAddress + "\n");
        }
    }

    public void receiveTreeCreateConf(DataInputStream is) {
        pktTreeCreateConf pkt = new pktTreeCreateConf(this.state.MyAddress);
        pkt.SetpktTreeCreateConf(is, this);
        if (!this.SenderISValid(pkt.SourceIPAddress)) {
            return;
        }
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
        if (nb == null) {
            this.nb_insert(pkt.SourceIPAddress, pkt.IPCoreAddress);
            nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
            if (pkt.IPCoreAddress.equals(this.state.CoreAddress)) {
                nb.Texpire = System.currentTimeMillis() + 100L;
            }
        }
        if (!this.state.ACKStatus || !this.CHECK_SEQ_NUM(nb.last_conf_sn, pkt.SequenceNumber)) {
            return;
        }
        this.state.ACKStatus = false;
        nb.last_conf_sn = pkt.SequenceNumber;
        nb.CoreAddress = pkt.IPCoreAddress;
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("received Tree-Create-Conf from " + pkt.SourceIPAddress + "\n");
        }
        if (this.state.ParentId.equals(pkt.SourceIPAddress)) {
            if (this.forwardingTreeCreate != null) {
                this.forwardTREE_CREATE(this.forwardingTreeCreate);
            }
            return;
        }
        if (!this.state.ParentId.equals(this.nullIP)) {
            this.sendTREE_CREATE_NACK(this.state.ParentId);
            return;
        }
        this.state.ParentId = pkt.SourceIPAddress;
        if (this.forwardingTreeCreate != null) {
            this.forwardTREE_CREATE(this.forwardingTreeCreate);
        }
    }

    public void receiveTreeCreateNackConf(DataInputStream is) {
        pktTreeCreateNackConf pkt = new pktTreeCreateNackConf(this.state.MyAddress);
        pkt.SetpktTreeCreateNackConf(is, this);
        if (!this.SenderISValid(pkt.SourceIPAddress)) {
            return;
        }
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
        if (nb == null) {
            this.nb_insert(pkt.SourceIPAddress, pkt.IPCoreAddress);
            nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
            if (pkt.IPCoreAddress.equals(this.state.CoreAddress)) {
                nb.Texpire = System.currentTimeMillis() + 100L;
            }
        }
        if (!this.state.NACKStatus || !this.CHECK_SEQ_NUM(nb.last_nack_conf_sn, pkt.SequenceNumber)) {
            return;
        }
        this.state.NACKStatus = false;
        this.CLEAR_TREE_LINK(pkt.SourceIPAddress);
        nb.last_nack_conf_sn = pkt.SequenceNumber;
        nb.CoreAddress = pkt.IPCoreAddress;
        this.state.ParentId = this.state.LastTreeCreateIn;
        if (this.forwardingTreeCreate != null) {
            this.forwardTREE_CREATE(this.forwardingTreeCreate);
        }
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("received Tree-Create-Nack-Conf from " + pkt.SourceIPAddress + "\n");
        }
    }

    public void receiveHelloConf(DataInputStream is) {
        pktHelloConf pkt = new pktHelloConf(this.state.MyAddress);
        pkt.SetpktHelloConf(is, this);
        if (!this.SenderISValid(pkt.SourceIPAddress)) {
            return;
        }
        OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
        if (nb == null) {
            this.nb_insert(pkt.SourceIPAddress, pkt.IPCoreAddress);
            nb = (OverlayNeighbor)this.neighbors.get(pkt.SourceIPAddress);
        }
        if (this.CHECK_SEQ_NUM(nb.hello_seq_num, pkt.SequenceNumber)) {
            nb.hello_seq_num = pkt.SequenceNumber;
            nb.CoreAddress = pkt.IPCoreAddress;
            nb.distance = pkt.TTL;
            if (pkt.TTL == 1) {
                if (pkt.IPCoreAddress.equals(this.state.CoreAddress)) {
                    nb.Texpire = System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Fast_Hello_loss * (double)this.fast_HELLO_INT);
                }
                this.fastHelloActive = true;
            } else if (pkt.IPCoreAddress.equals(this.state.CoreAddress)) {
                nb.Texpire = System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Hello_loss * (double)this.HELLO_INT);
            }
        }
        this.state.hello_found_neighbour = true;
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("received Hello-Conf from " + pkt.SourceIPAddress + "\n");
        }
    }

    boolean CORE_RESOLUTION(pktTreeCreate pkt) {
        int ip2;
        if (this.state.getIPCoreAddress() == null) {
            this.state.setCoreAddress(pkt.IPCoreAddress);
            return true;
        }
        if (pkt.SourceIPAddress.equals(this.state.ParentId) && !this.state.getIPCoreAddress().equals(pkt.IPCoreAddress)) {
            this.state.setCoreAddress(pkt.IPCoreAddress);
            this.state.is_core = false;
            this.state.TreeCreateSequenceNumber = 0;
            return true;
        }
        int ip1 = this.state.getAddressInt(this.state.CoreAddress);
        if (ip1 < (ip2 = this.state.getAddressInt(pkt.IPCoreAddress))) {
            return false;
        }
        if (ip1 == ip2) {
            return true;
        }
        this.state.setCoreAddress(pkt.IPCoreAddress);
        this.state.is_core = false;
        this.state.TreeCreateSequenceNumber = 0;
        return true;
    }

    boolean CHECK_SEQ_NUM(pktTreeCreate pkt) {
        int pktTCSN;
        int stateTCSN = this.state.TreeCreateSequenceNumber;
        if (stateTCSN < 0) {
            stateTCSN += 256;
        }
        if ((pktTCSN = pkt.SequenceNumber) < 0) {
            pktTCSN += 256;
        }
        if ((double)Math.abs(pktTCSN - stateTCSN) > 5.0) {
            return true;
        }
        return stateTCSN <= pktTCSN;
    }

    void CLEAR_NUMBER_TREE_CREATE() {
        Enumeration e = this.neighbors.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
            value.ResetNumberTCS();
        }
    }

    public void receiveVirtualFastHello(String address_) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(address_);
        if (!this.SenderISValid(address)) {
            return;
        }
        if (this.sig_dump_box.getState()) {
            this.outputArea.append("received Virtual-Fast-Hello from " + address + "\n");
        }
        if (!this.neighbors.containsKey(address) && !address.equals(this.state.MyAddress)) {
            this.nb_insert(address, this.state.CoreAddress);
            OverlayNeighbor overlay_neighbor = (OverlayNeighbor)this.neighbors.get(address);
            overlay_neighbor.Texpire = System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Fast_Hello_loss * (double)this.fast_HELLO_INT);
            overlay_neighbor.distance = 1;
            return;
        }
        if (this.neighbors.containsKey(address)) {
            OverlayNeighbor nb = (OverlayNeighbor)this.neighbors.get(address);
            nb.CoreAddress = this.state.CoreAddress;
            nb.distance = 1;
            nb.Texpire = System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Fast_Hello_loss * (double)this.fast_HELLO_INT);
            return;
        }
    }

    public void receiveJoin(byte[] pkt_) {
        pktJoin pkt = new pktJoin(this.state.MyAddress);
        pkt.SetpktJoin(pkt_, this);
        if (!this.SenderISValid(pkt.SourceIPAddress)) {
            return;
        }
        for (int t = 0; t < this.mesh_list_vector.length; ++t) {
            if (!this.mesh_list_vector[t].equals(pkt.SourceIPAddress.toString().substring(1, pkt.SourceIPAddress.toString().length()))) continue;
            if (this.JoinedList[t] != null) {
                if (!this.CHECK_SEQ_NUM(this.JoinedList[t].JoinSequenceNumber, pkt.SequenceNumber)) continue;
                this.JoinedList[t] = new JoinedListEntry("0", this.mesh_list_vector[t], System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Join_loss * (double)this.JOIN_INT), pkt.SequenceNumber);
                this.forwardJOIN(pkt_);
                continue;
            }
            this.JoinedList[t] = new JoinedListEntry("0", this.mesh_list_vector[t], System.currentTimeMillis() + (long)(1.5 * (double)this.Allowed_Join_loss * (double)this.JOIN_INT), pkt.SequenceNumber);
        }
    }

    public void forwardJOIN(byte[] pkt_) {
        boolean multicast_done = false;
        byte[] pktNodeMapJoinPacket = new byte[8];
        byte[] pktNodeMapJoin = new byte[8];
        int number_of_sent = 0;
        InetAddress[] AddressArray = new InetAddress[64];
        for (int element = 0; element < pktNodeMapJoinPacket.length; ++element) {
            pktNodeMapJoinPacket[element] = pkt_[element + 3];
            pktNodeMapJoin[element] = pkt_[element + 3];
        }
        this.node_map_insert_Join(this.state.getAddressString(), pktNodeMapJoin);
        this.node_map_insert_Join(this.state.getAddressString(), pktNodeMapJoinPacket);
        Enumeration e = this.neighbors.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            OverlayNeighbor value = (OverlayNeighbor)this.neighbors.get(key);
            if (this.check.getState()) {
                if (!value.istree && value.distance != 1 || !this.SenderISValid(value.IPAddress) || this.node_map_lookup_Join(value.IPAddress.toString().substring(1, value.IPAddress.toString().length()), pktNodeMapJoinPacket)) continue;
                if (value.distance > 1) {
                    this.node_map_insert_Join(value.getAddressString(), pktNodeMapJoin);
                    AddressArray[++number_of_sent - 1] = value.IPAddress;
                    continue;
                }
                if (value.distance != 1) continue;
                this.node_map_insert_Join(value.getAddressString(), pktNodeMapJoin);
                if (multicast_done) continue;
                multicast_done = true;
                continue;
            }
            if (!value.istree || this.node_map_lookup_Join(value.IPAddress.toString().substring(1, value.IPAddress.toString().length()), pktNodeMapJoinPacket)) continue;
            this.node_map_insert_Join(value.getAddressString(), pktNodeMapJoin);
            AddressArray[++number_of_sent - 1] = value.IPAddress;
        }
        pktJoin packt = new pktJoin(this.state.MyAddress);
        packt.SetpktJoin(pkt_, this);
        pktJoin pkt = new pktJoin(packt.SequenceNumber, packt.SourceIPAddress, pktNodeMapJoin, this);
        if (multicast_done) {
            MulticastData mData = new MulticastData(pkt.getData(), 1);
            this.MSigSend.q.add(mData);
            if (this.sig_dump_box.getState()) {
                this.outputArea.append("forward broadcast Join\n");
            }
        }
        for (int i = 0; i < number_of_sent; ++i) {
            UnicastData usp = new UnicastData(pkt.getData(), AddressArray[i]);
            this.USigSend.q.add(usp);
            if (!this.sig_dump_box.getState()) continue;
            this.outputArea.append("forward Join to " + AddressArray[i] + "\n");
        }
    }

    public void sendJoin() {
        boolean multicast_done = false;
        int number_of_sent = 0;
        InetAddress[] AddressArray = new InetAddress[64];
        byte[] node_map_Join = new byte[8];
        this.node_map_insert_Join(this.state.getAddressString(), node_map_Join);
        int JSN = this.state.JoinSequenceNumber;
        if (JSN < 0) {
            JSN += 256;
        }
        if (++JSN > 255) {
            JSN = 1;
        }
        this.state.JoinSequenceNumber = (byte)JSN;
        Enumeration enu = this.neighbors.keys();
        while (enu.hasMoreElements()) {
            Object keyu = enu.nextElement();
            OverlayNeighbor valueu = (OverlayNeighbor)this.neighbors.get(keyu);
            if (this.check.getState()) {
                if (!valueu.istree && valueu.distance != 1 || !this.SenderISValid(valueu.IPAddress)) continue;
                if (valueu.distance == 1) {
                    this.node_map_insert_Join(valueu.getAddressString(), node_map_Join);
                    if (multicast_done) continue;
                    multicast_done = true;
                    continue;
                }
                if (valueu.distance <= 1) continue;
                this.node_map_insert_Join(valueu.getAddressString(), node_map_Join);
                AddressArray[++number_of_sent - 1] = valueu.IPAddress;
                continue;
            }
            if (!valueu.istree) continue;
            this.node_map_insert_Join(valueu.getAddressString(), node_map_Join);
            AddressArray[++number_of_sent - 1] = valueu.IPAddress;
        }
        pktJoin pkt = new pktJoin(this.state.JoinSequenceNumber, this.state.MyAddress, node_map_Join, this);
        if (multicast_done) {
            MulticastData mData = new MulticastData(pkt.getData(), 1);
            this.MSigSend.q.add(mData);
            if (this.sig_dump_box.getState()) {
                this.outputArea.append(this.state.JoinSequenceNumber + " send broadcast Join" + "\n");
            }
        }
        for (int i = 0; i < number_of_sent; ++i) {
            UnicastData usp = new UnicastData(pkt.getData(), AddressArray[i]);
            this.USigSend.q.add(usp);
            if (!this.sig_dump_box.getState()) continue;
            this.outputArea.append(this.state.JoinSequenceNumber + " send Join to " + AddressArray[i] + "\n");
        }
    }

    public void Mesh_list_creator() throws IOException {
        int t;
        String str_obamp_nodes;
        int i = 0;
        FileReader obamp_nodes = new FileReader("obamp_nodes.txt");
        BufferedReader obamp_nodesb = new BufferedReader(obamp_nodes);
        while ((str_obamp_nodes = obamp_nodesb.readLine()) != null) {
            ++i;
        }
        obamp_nodes = new FileReader("obamp_nodes.txt");
        obamp_nodesb = new BufferedReader(obamp_nodes);
        this.mesh_list_vector = new String[i];
        this.JoinedList = new JoinedListEntry[i];
        this.MEMBER_LIST = new InetAddress[i];
        this.mesh_list_vector_Inet = new InetAddress[i];
        for (t = 0; t < i; ++t) {
            this.mesh_list_vector[t] = str_obamp_nodes = obamp_nodesb.readLine();
        }
        for (t = 0; t < i; ++t) {
            this.mesh_list_vector_Inet[t] = InetAddress.getByName(this.mesh_list_vector[t]);
        }
    }

    public InetAddress getAddresspkt(byte Address) {
        int id = Address;
        if (id < 0) {
            id += 256;
        }
        return this.mesh_list_vector_Inet[id];
    }

    public byte getIAddresspkt(InetAddress Address) {
        int id = 0;
        for (int t = 0; t < this.mesh_list_vector.length && !this.mesh_list_vector_Inet[t].equals(Address); ++t) {
            ++id;
        }
        return (byte)id;
    }

    public void route_print(String command) throws IOException {
        Runtime.getRuntime().exec(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.USigRec = new UnicastSignallingReceiver(this.sig_port, this.state.MyAddress, this);
            this.USigSend = new UnicastSignallingSender(this.state.MyAddress, this.sig_port - 1, this.sig_port, this);
            this.MSigRec = new MulticastSignallingReceiver(this.state.MyAddress, this.broadcast_port, this.multicast_address, this);
            this.MSigSend = new MulticastSignallingSender(this.state.MyAddress, this.broadcast_port, this.multicast_address);
            this.Mesh_list_creator();
            new JoinedTimer(this);
            if (this.Operative_System.equals("Windows")) {
                new FastHelloTimerWindows(this);
            } else if (this.Operative_System.equals("Linux")) {
                new FastHelloTimerLinux(this);
            }
            new TREE_CREATETimer(this);
            new HelloTimer(this);
            new nb_purge(this);
            this.rgui = new refreshGUI(this);
            while (true) {
                block12: {
                    SignallingElement spkt = (SignallingElement)this.q.remove();
                    DatagramPacket packet = spkt.dpacket;
                    String string = this.signalling_use;
                    synchronized (string) {
                        block11: {
                            if (this.old_neighbors == null) break block11;
                            OverlayNeighbor nb_old = (OverlayNeighbor)this.old_neighbors.get(spkt.src);
                            if (nb_old != null) {
                                if ((double)(System.currentTimeMillis() - nb_old.last_failure_time) > 1.5 * (double)this.Allowed_Alive_Hello_loss * (double)this.Alive_Hello_intervall) {
                                    this.receive(packet);
                                }
                                break block12;
                            } else {
                                this.receive(packet);
                            }
                            break block12;
                        }
                        this.receive(packet);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

